#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "./q3s.h"

static const char *his_team[3] = {"free", "red ", "blue"};

static const char *clr_team[3] = {"\e[38;2;255;255;255mfree\e[0m", "\e[38;2;255;0;0mred \e[0m", "\e[38;2;0;0;255mblue\e[0m"};

static const char *his_race[6] = {"human", "bot_1", "bot_2", "bot_3", "bot_4", "bot_5"};

static const char *gametype[7] = {"FFA", "TOURNAMENT", "SINGLE_PLAYER", "TEAM", "CTF", "CA", "MAX_GAME_TYPE"};

static const char *clean_weapons[10] = {"Gauntlet ", "Machine  ", "Shotgun  ", "Grenade  ", "Rocket   ", "Lightning", "Rail     ", "Plasma   ", "BFG      ", "Grappling"};
static const char *color_weapons[10] = {"\e[38;2;0;216;255mGauntlet \e[0m", "\e[38;2;255;255;0mMachine  \e[0m", "\e[38;2;255;125;0mShotgun  \e[0m", "\e[38;2;2;144;18mGrenade  \e[0m", "\e[38;2;255;1;1mRocket   \e[0m", "\e[38;2;255;255;176mLightning\e[0m", "\e[38;2;2;232;1mRail     \e[0m", "\e[38;2;197;0;255mPlasma   \e[0m", "\e[38;2;1;90;255mBFG      \e[0m", "\e[38;2;0;201;149mGrappling\e[0m"};

//=============================================================================

static struct stats_s  S;
static struct match_s  M;
static struct player_s P[MAX_CLIENTS];

static const char *color[10] = {"\e[38;2;0;0;0m", "\e[38;2;255;0;0m", "\e[38;2;0;255;0m", "\e[38;2;255;255;0m", "\e[38;2;0;0;255m", "\e[38;2;0;255;255m", "\e[38;2;255;0;255m", "\e[38;2;255;255;255m", "\e[38;2;255;127;0m", "\e[38;2;127;127;127m"};

void make_color(char *raw, char *out)
{
    int o = 0;
    int l = 7;
    for(int i = 0; raw[i]; i++)
    {
        char c = raw[i];

        if(c == '\x19')
        {
            continue;
        }
        if(c != '^')
        {
            out[o++] = c;
            continue;
        }

        char m = raw[i + 1];
        if(m == '^')
        {
            out[o++] = m;
            continue;
        }
        if(m >= '0' && m <= '9')
        {
            if(l != -1)
            {
                o += sprintf(out + o, "\e[0m");
                l = -1;
            }
            o += sprintf(out + o, "%s", color[m - '0']);
            l = m;
        }
        i++;
    }
    if(l != -1)
    {
        o += sprintf(out + o, "\e[0m");
        l = -1;
    }
}

int main(int argc, char **argv)
{
    if(argc < 2)
    {
        printf("[arg1] = path/to/file.q3s (arg2) = 0 - clean 1 - color 2 - clean short 3 - color short\n");
        return -1;
    }

    FILE *f = fopen(argv[1], "rb");
    if(f == NULL)
    {
        printf("can't open file\n");
        return -1;
    }
    fseek(f, 0, SEEK_END);
    int in_len = ftell(f);
    fseek(f, 0, SEEK_SET);

    int is_color = 0;
    int is_short = 0;
    if(argc > 2)
    {
        is_color = atoi(argv[2]) & (1 << 0);
        is_short = atoi(argv[2]) & (1 << 1);
    }

    qread(f, in_len, &S, &M, P);

    fclose(f);

    printf("----------------------------------------------------------------------------------------------------\n");
    printf("version %d\n", S.version);
    printf("m_size %d\n", S.m_size);
    printf("p_size %d\n", S.p_size);
    printf("----------------------------------------------------------------------------------------------------\n");
    printf("mapname    : %s\n", M.map);
    printf("init time  : %d.%d.%d %d:%d:%d\n", M.map_init.tm_year + 1900, M.map_init.tm_mon, M.map_init.tm_mday, M.map_init.tm_hour, M.map_init.tm_min, M.map_init.tm_sec);
    printf("free time  : %d.%d.%d %d:%d:%d\n", M.map_free.tm_year + 1900, M.map_free.tm_mon, M.map_free.tm_mday, M.map_free.tm_hour, M.map_free.tm_min, M.map_free.tm_sec);
    printf("gametype   : %s\n", gametype[M.type]);
    printf("fraglimit  : %d\n", M.frag_limit);
    printf("timelimit  : %d\n", M.time_limit);
    printf("flaglimit  : %d\n", M.flag_limit);
    printf("red    name: %s\n", M.r_team);
    printf("blue   name: %s\n", M.b_team);
    printf("red  scores: %d\n", M.r_scores);
    printf("blue scores: %d\n", M.b_scores);
    printf("----------------------------------------------------------------------------------------------------\n");

    for(int i = 0; i < MAX_CLIENTS; i++) {
        struct player_s p = P[i];
        if(p.team == TEAM_RED) {
            if(is_color) {
                char color[512] = {0};
                make_color(p.color, color);
                printf("race: %s team: %s CLEAN: %s COLOR: %s\n", his_race[p.race], clr_team[p.team], p.clean, color);
                printf("\e[38;2;0;255;0mGA\e[0m: %d \e[38;2;255;255;0mYA\e[0m: %d \e[38;2;255;0;0mRA\e[0m: %d \e[38;2;0;0;255mMH\e[0m: %d\n", p.ga, p.ya, p.ra, p.mh);
            } else {
                printf("race: %s team: %s CLEAN: %s COLOR: %s\n", his_race[p.race], his_team[p.team], p.clean, p.color);
                printf("GA: %d YA: %d RA: %d MH: %d\n", p.ga, p.ya, p.ra, p.mh);
            }
            printf("AT: %d HT: %d DG: %d GR: %d\n", p.at, p.ht, p.dg, p.dr);
            printf("kills: %d thaws: %d deaths: %d unfreezes: %d suicides: %d\n", p.k, p.t, p.d, p.u, p.s);
            for(int w = 0; w < 10; w++)
            {
                if(p.weapon[w][0] || p.weapon[w][1] || !is_short)
                {
                    if(is_color)
                    {
                        printf("%s hits %4d atts %4d kills %2d deaths %2d\n", color_weapons[w], p.weapon[w][0], p.weapon[w][1], p.weapon[w][2], p.weapon[w][3]);
                    }
                    else
                    {
                        printf("%s hits %4d atts %4d kills %2d deaths %2d\n", clean_weapons[w], p.weapon[w][0], p.weapon[w][1], p.weapon[w][2], p.weapon[w][3]);
                    }
                }
            }
            printf("----------------------------------------------------------------------------------------------------\n");
        }
    }
    for(int i = 0; i < MAX_CLIENTS; i++) {
        struct player_s p = P[i];
        if(p.team == TEAM_BLUE) {
            if(is_color) {
                char color[512] = {0};
                make_color(p.color, color);
                printf("race: %s team: %s CLEAN: %s COLOR: %s\n", his_race[p.race], clr_team[p.team], p.clean, color);
                printf("\e[38;2;0;255;0mGA\e[0m: %d \e[38;2;255;255;0mYA\e[0m: %d \e[38;2;255;0;0mRA\e[0m: %d \e[38;2;0;0;255mMH\e[0m: %d\n", p.ga, p.ya, p.ra, p.mh);
            } else {
                printf("race: %s team: %s CLEAN: %s COLOR: %s\n", his_race[p.race], his_team[p.team], p.clean, p.color);
                printf("GA: %d YA: %d RA: %d MH: %d\n", p.ga, p.ya, p.ra, p.mh);
            }
            printf("AT: %d HT: %d DG: %d GR: %d\n", p.at, p.ht, p.dg, p.dr);
            printf("kills: %d thaws: %d deaths: %d unfreezes: %d suicides: %d\n", p.k, p.t, p.d, p.u, p.s);
            for(int w = 0; w < 10; w++)
            {
                if(p.weapon[w][0] || p.weapon[w][1] || !is_short)
                {
                    if(is_color)
                    {
                        printf("%s hits %4d atts %4d kills %2d deaths %2d\n", color_weapons[w], p.weapon[w][0], p.weapon[w][1], p.weapon[w][2], p.weapon[w][3]);
                    }
                    else
                    {
                        printf("%s hits %4d atts %4d kills %2d deaths %2d\n", clean_weapons[w], p.weapon[w][0], p.weapon[w][1], p.weapon[w][2], p.weapon[w][3]);
                    }
                }
            }
            printf("----------------------------------------------------------------------------------------------------\n");
        }
    }
    return 0;
}
