#ifndef _Q3S_H_
#define _Q3S_H_

//=============================================================================

typedef unsigned short u16;
typedef unsigned int   u32;
typedef          short i16;
typedef          int   i32;

//=============================================================================

typedef enum
{
    TEAM_FREE,
    TEAM_RED,
    TEAM_BLUE,
    TEAM_SPECTATOR,
    TEAM_4,
    TEAM_5,
    TEAM_6,
    TEAM_7,
    TEAM_NUM_TEAMS
} team_t;

typedef enum
{
    GT_FFA,             // free for all
    GT_TOURNAMENT,      // one on one tournament
    GT_SINGLE_PLAYER,   // single player ffa

    //-- team games go after this --

    GT_TEAM,            // team deathmatch
    GT_CTF,             // capture the flag
    GT_CA,
    GT_MAX_GAME_TYPE
} gametype_t;

typedef struct qtime_s
{
    int32_t tm_sec;     /* seconds after the minute - [0,59] */
    int32_t tm_min;     /* minutes after the hour - [0,59] */
    int32_t tm_hour;    /* hours since midnight - [0,23] */
    int32_t tm_mday;    /* day of the month - [1,31] */
    int32_t tm_mon;     /* months since January - [0,11] */
    int32_t tm_year;    /* years since 1900 */
    int32_t tm_wday;    /* days since Sunday - [0,6] */
    int32_t tm_yday;    /* days since January 1 - [0,365] */
    int32_t tm_isdst;   /* daylight savings time flag */
} __attribute__((packed, aligned(1))) qtime_t;

#define MAX_QPATH 64
#define MAX_CLIENTS 64

struct __attribute__((packed, aligned(1))) stats_s
{
    i32 version;
    u16 m_size;
    u16 p_size;
};

struct __attribute__((packed, aligned(1))) match_s
{
    char map[MAX_QPATH];
    char r_team[MAX_QPATH];
    char b_team[MAX_QPATH];
    i32 r_scores;
    i32 b_scores;
    qtime_t map_init;
    qtime_t map_free;
    gametype_t type;
    i32 frag_limit;
    i32 time_limit;
    i32 flag_limit;
};

struct __attribute__((packed, aligned(1))) player_s
{
    char clean[MAX_QPATH]; // clean name
    char color[MAX_QPATH]; // colors ^123456789
    u16 ga;
    u16 ya;
    u16 ra;
    u16 mh;
    u16 at;
    u16 ht;
    u32 dg;
    u32 dr;
    u16 k; //kills
    u16 t; //thaws
    u16 d; //deaths
    u16 u; //unfreezes
    u16 s; //suicide
    u16 weapon[10][4]; //[weap_index][0 = hits 1 = atts 2 = kills 3 = deaths ]
    u16 ktable[MAX_CLIENTS]; //kills
    u16 ttable[MAX_CLIENTS]; //thaws

    i16    race;
    team_t team;

    u32 time; // ms
};

struct tm tm_copy(qtime_t *a)
{
    struct tm t = {0};
    t.tm_sec = a->tm_sec;     /* seconds after the minute - [0,59] */
    t.tm_min = a->tm_min;     /* minutes after the hour - [0,59] */
    t.tm_hour = a->tm_hour;    /* hours since midnight - [0,23] */
    t.tm_mday = a->tm_mday;    /* day of the month - [1,31] */
    t.tm_mon = a->tm_mon;     /* months since January - [0,11] */
    t.tm_year = a->tm_year;    /* years since 1900 */
    t.tm_wday = a->tm_wday;    /* days since Sunday - [0,6] */
    t.tm_yday = a->tm_yday;    /* days since January 1 - [0,365] */
    t.tm_isdst = a->tm_isdst;   /* daylight savings time flag */
    return t;
}

int max(int a, int b) {return a > b ? a : b;}

int min(int a, int b) {return a < b ? a : b;}

int rle_decode(int size, char *raw, char *out)
{
    int o = 0;
    for(int i = 0; i < size;)
    {
        char cmd = raw[i];
        char add = max(cmd, -cmd);
        if(cmd > 0)
        {
            while(cmd--)
            {
                out[o++] = raw[i+1];
            }
            i += 1 + 1;
        } else
        {
            memcpy(&out[o], &raw[i+1], add);
            o += add;
            i += 1 + add;
        }
    }
    return o;
}

void qread(FILE *f, int raw_len, struct stats_s *s, struct match_s *m, struct player_s p[MAX_CLIENTS])
{
    char raw[65536] = {0};
    char out[65536] = {0};

    fread(raw, raw_len, 1, f);

    int out_len = rle_decode(raw_len, raw, out);

    int pos = 0;
    memcpy(s, &out[pos], sizeof(*s));
    pos += sizeof(*s);
    memcpy(m, &out[pos], sizeof(*m));
    pos += sizeof(*m);
    memcpy(p, &out[pos], sizeof(struct player_s) * MAX_CLIENTS);
    pos += sizeof(*p);
}

#endif /* _Q3S_H_ */
